﻿using System;
using System.ServiceModel;
using System.ServiceModel.Description;
using Microsoft.ServiceBus;
using ServiceBusUtils;
using EnergyServiceContract;

namespace NetEventRelayServer
{
 class Program
 {
  static void Main(string[] args)
  {
   try
   {
    string serviceNamespaceDomain = ServiceBusHelper.GetServiceBusSolutionName();
    string issuerName = "owner";
    string issuerSecret = "qUWEWVXvF3ENS95Kw5/OI1JauU+0tRHetvkLpIHVELw=";
    ServiceBusEnvironment.SystemConnectivity.Mode = ConnectivityMode.AutoDetect;
   
    TransportClientEndpointBehavior relayCredentials = new TransportClientEndpointBehavior();
    relayCredentials.CredentialType = TransportClientCredentialType.SharedSecret;
    relayCredentials.Credentials.SharedSecret.IssuerName = issuerName;
    relayCredentials.Credentials.SharedSecret.IssuerSecret = issuerSecret;
    Uri serviceAddress = ServiceBusEnvironment.CreateServiceUri("sb", serviceNamespaceDomain,
               "gateway/MulticastService/");
    ServiceHost host = new ServiceHost(typeof(MulticastGatewayOperations), serviceAddress);
    host.Description.Endpoints[0].Behaviors.Add(relayCredentials);
    host.Open();


    Console.WriteLine("ServiceUri:" + serviceAddress.ToString());

    Console.WriteLine("Usługa zarejestrowana. Dostępna do publicznego użytku.");
    NetEventRelayBinding binding = host.Description.Endpoints[0].Binding as NetEventRelayBinding;
    if (binding != null)
    {
        Console.WriteLine("Schemat:" + binding.Scheme);
        Console.WriteLine("Tryb zabezpieczeń:" + binding.Security.Mode);
        Console.WriteLine("Zabezpieczenie RelayAuthType:" + binding.Security.RelayClientAuthenticationType.ToString());
        Console.WriteLine("Zabezpieczenie Transport.ProtectionLevel:" + binding.Security.Transport.ProtectionLevel.ToString());



    }
    Console.WriteLine("Wciśnij [Enter], aby zakończyć");
    Console.ReadLine();

    host.Close();
   }
   catch (Exception ex)
   {
    Console.WriteLine(ex.Message);

   }
  }


 }
}
